#include "bdtypes.h"
#include "bdglobal.h"
#include "bdfunc.h"

#ifndef WIN32
#include <sys/time.h>
#endif

#ifdef WIN32

// Function name	: ErrorMessage
// Description	    : 
// Return type		: void 
// Argument         : char *szMessage
void ErrorMessage(char *szMessage)
{
	MessageBox(NULL, szMessage, "Erreur", MB_OK);
}


// Function name	: TickCount
// Description	    : 
// Return type		: DWORD 
DWORD TickCount()
{
	return GetTickCount();
}

#else
// Function name	: ErrorMessage
// Description	    : 
// Return type		: void 
// Argument         : char *szMessage
void ErrorMessage(char *szMessage)
{
	printf("Erreur: %s\n", szMessage);
}

// Function name	: TickCount
// Description	    : 
// Return type		: DWORD 
DWORD TickCount()
{


	return ;
}
#endif

// Function name	: HardInit
// Description	    : 
// Return type		: bool 
BOOL HardInit()
{
	GrHwConfiguration hw;		
	DWORD memvar;

	g_FrameBuf3d = malloc(65536*2);
	if (g_FrameBuf3d==0)
		return FALSE;

	// Bah bah, Splash logo !
	putenv("FX_GLIDE_NO_SPLASH=1");

	// 3dfx !
	//printf("grGlideInit()\n");
	grGlideInit();	// initialize the glide
	//printf("end grGlideInit()\n");
	if (!grSstQueryHardware(&hw))
	{
		grGlideShutdown();
		exit(1);
	}; // No 3Dfx chipset!
	grSstSelect(0);	// choose the first voodoo card in the computer
	// bind a window and the drawing area
	grSstWinOpen((FxU32) 0, GR_RESOLUTION_640x480, GR_REFRESH_75Hz,
		GR_COLORFORMAT_ARGB, GR_ORIGIN_UPPER_LEFT, 2, 1);

	fprintf(stderr, "Glide library ready\n");

	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthMask(FXTRUE);
	grColorMask(FXTRUE, FXFALSE);


	grTexCombine(GR_TMU0,
					GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_LOCAL,	//	rgb
					GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_LOCAL,	//	alpha
					FXFALSE, FXFALSE);
	grTexMipMapMode(GR_TMU0,GR_MIPMAP_NEAREST,FXFALSE);
	grTexClampMode(GR_TMU0, GR_TEXTURECLAMP_WRAP, GR_TEXTURECLAMP_WRAP);
	grTexFilterMode(GR_TMU0, GR_TEXTUREFILTER_BILINEAR, 
					GR_TEXTUREFILTER_BILINEAR);

	//grTexFilterMode(GR_TMU0, GR_TEXTUREFILTER_POINT_SAMPLED, GR_TEXTUREFILTER_POINT_SAMPLED);

	g_StartTextMem = grTexMinAddress(GR_TMU0);
	g_EndTexMem = grTexMaxAddress(GR_TMU0);
	g_FrameBuf3d = malloc(sizeof(WORD)*65536);
	g_TextureBuff.start = g_StartTextMem;
	g_TextureBuff.info.data = g_FrameBuf3d;
	g_StartTextMem += sizeof(WORD[65536]);

	guFogGenerateExp(g_FogTunnel, 0.021f);

	guFogGenerateExp(g_FogCubeField, 0.0015f);
	guFogGenerateExp(g_FogPlanes, 0.00005f);
	guFogGenerateExp2(g_FogFlaque, 0.0016f);
	guFogGenerateExp2(g_FogRoom, 0.0016f);
	guFogGenerateExp(g_FogHomer, 0.009f);
	guFogGenerateExp2(g_FogPing, 0.003f);

	return true;
}


// Function name	: ShutDown
// Description	    : 
// Return type		: void 
void ShutDown()
{
	ModuleShutDown();

	if (g_demostate.TwoMonitors == FALSE)
	{
		grSstControl(GR_CONTROL_DEACTIVATE);
		grSstWinClose();
		grGlideShutdown();
	}
}


// Function name	: InitModule
// Description	    : 
// Return type		: void 
// Argument         : char *FileName
void InitModule(char *FileName)
{
	BOOL res;

	res = MIDASstartup();
	if (res == true)
		g_demostate.musicstate = MusicStartup;
	else
		return;

	// Use DirectSound only with win32
#ifndef WIN32
	if (g_demostate.DirectSound == true)
	{
		MIDASsetOption(MIDAS_OPTION_DSOUND_HWND, (DWORD)g_demostate.hwnd);
		MIDASsetOption(MIDAS_OPTION_DSOUND_MODE, MIDAS_DSOUND_PRIMARY);
		MIDASsetOption(MIDAS_OPTION_DSOUND_BUFLEN, 2000);
	}
#endif

	//MIDASsetOption(MIDAS_OPTION_FILTER_MODE, MIDAS_FILTER_NONE);
	//MIDASsetOption(MIDAS_OPTION_MIXING_MODE, MIDAS_MIX_NORMAL_QUALITY);
	//MIDASsetOption(MIDAS_OPTION_OUTPUTMODE, MIDAS_MODE_8BIT_MONO);
	
	res = MIDASinit();
	if (res == true)
		g_demostate.musicstate = MusicInit;
	else
		return;

	res = MIDASstartBackgroundPlay(0);
	if (res == true)
		g_demostate.musicstate = MusicBackground;
	else
		return;

	g_demostate.module = MIDASloadModule(FileName);
	if (g_demostate.module != NULL)
		g_demostate.musicstate = MusicLoadModule;
	else
		return;
}

// Function name	: ModuleShutDown
// Description	    : 
// Return type		: void 
void ModuleShutDown()
{
	if (g_demostate.NoSoundMode == false)
		MIDASclose();
}
